﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KursBeispiele
{
    public partial class Form1 : Form
    {
        //Kein Parameterloser Konstruktor
        public Form1(string argument)
        {
            InitializeComponent();
            //Setze den Text des Label-Objektes
            arg.Text = argument;
            //Event Handler hinzufügen
            MouseMove += new MouseEventHandler(Form1_MouseMove);
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            //Diese Funktion funktioniert nur wenn die Message MOUSEMOVE nicht gefiltert wird
            //Sie funktioniert dann auf ALLEN Formularen
            if (checkBox1.Checked)
                listBox1.Items.Add(e.ToString());
        }

        public void Clicked(object sender, EventArgs e)
        {
            //Diese Funktion funktioniert nur wenn die Message MOUSEMOVE gefiltert wird
            //Sie funktioniert dann nur auf dem HAUPTFORMULAR
            if(!checkBox1.Checked)
                listBox1.Items.Add(sender.ToString());
        }

        //Event Handler für Button zum Zeigen des Startpfades
        private void button1_Click(object sender, EventArgs e)
        {
            //Nutze statische Eigenschaften der Application Klasse aus
            new Form1(Application.StartupPath).Show();
        }

        //Event Handler für Button zum Zeigen der aktuellen Sprache
        private void button2_Click(object sender, EventArgs e)
        {
            //Nutze wieder die statischen Eigenschaften aus
            new Form1(Application.CurrentCulture.DisplayName).Show();
        }

        //Event Handler für Button zum Schließen der offenen Formulare
        private void button3_Click(object sender, EventArgs e)
        {
            //Wir lassen ID=0 aus da dies unser Hauptformular darstellt
            for (int i = Application.OpenForms.Count - 1; i > 0; i--)
                Application.OpenForms[i].Close();
            
            //Dies würde schon nicht gehen weil es auch ID=0 kicken würde
            //aber abgesehen davon geht es nicht, da die foreach-Schleife
            //eine Konstante Liste benötigt, d.h. es dürfen keine Änderungen
            //während der Schleifenausführung an dieser vorgenommen werden.
            //foreach (Form f in Application.OpenForms)
            //    f.Close();
        }
    }
}
